#include "basics.hxx"
#include "audio/effectchain.hxx"
#include "audio/audio_io.hxx"
#include "shortcuts.hxx"
#include "tstring.hxx"

#include "debug.hxx"


const audio_io_type inval = 42;
const unsigned int chan = 1;

class testinput: public audio::source
{
	public:
	 testinput(){ format.rate=44100; format.channels=chan; format.encoding=audio::audio_io_code; };
	~testinput(){};
	bool do_read(void* buf, size_t wanted_bytes, size_t &got_bytes)
	{
		audio_io_type* samples = (audio_io_type*)buf;
		size_t count = audio::bytes_to_samples(format.encoding, wanted_bytes);
		for(size_t i=0; i<count; ++i)
		samples[i] = inval;

		got_bytes = audio::samples_to_bytes(format.encoding, count);
		printf("Gave %zu bytes.\n", got_bytes);
		return true;
	}
};

void report(dmd::effect::chain &fc)
{
	errorchain errors;
	std::vector<std::string*> messages;
	fc.collect_errors(errors);
	errors.stringify(messages);
	fprintf(stderr, "Error messages:\n");
	FOR_VECTOR(std::string*, messages, msg)
	{
		fprintf(stderr, "%s\n", (*msg)->c_str());
		delete *msg;
	}
	messages.clear();
}

#define FAIL { ++err; goto end; }
#define CHECK(a) if(!(a)) FAIL;

int main(int argc, char **argv)
{
	int err = 0;
	float amp = 2.;
	mixer_buffer mbuf(chan, 100);
	testinput blubber;
	dmd::effect::chain fc;
	std::string parstring;

	fprintf(stderr, "starting operation, insert amplify\n");
	strprintf(parstring, "%g", amp);
	CHECK(fc.insert("amplify"));
	fc.set_pars(parstring);
	fprintf(stderr, "insert copy\n");
	CHECK(fc.insert("copy"));
	fprintf(stderr, "set source\n");
	CHECK(fc.set_source(&blubber));
	fprintf(stderr, "receive\n");
	CHECK(fc.receive(mbuf, mbuf.size));

	if(mbuf.fill != mbuf.size)
	{
		MERROR("Only got %zu/%zu samples.", mbuf.fill, mbuf.size);
		FAIL;
	}

	fprintf(stderr, "done receiving, checking\n");
	for(size_t i= 0; i<mbuf.fill*mbuf.channels; ++i)
	{
		float ref = -1.;
		size_t count;
		audio::encode_from(blubber.format.encoding, &inval, sizeof(inval), &ref, 1, count);
		ref *= amp;
		// It should be exact...
		if(mbuf.ptr[i] != ref)
		{
			MERROR("Bad value of sample %zu: %g != %g", i, mbuf.ptr[i], ref);
			FAIL;
		}
	}

end:
	if(err) report(fc);
	printf("%s\n", err ? "FAIL" : "PASS");
	return err;
}
