// Simple test for audio format conversions.
// It checks if from-and-back conversion between s16 and f32 is error-free.
// This is for hard clipping...

#include "basics.hxx"
#include "audio/audio_format.hxx"

int check_scale(float scale, int16_t val);

int main(int argc, char **argv)
{
	int errs = 0;
	const int count = 1<<16;
	int16_t start = -32768;
	int16_t inbuf[count], outbuf[count];
	audio_type mixbuf[count];
	size_t samples, bytes;

	// Tests of getting single sample values from scaling.
	errs += check_scale(0., 0);
	errs += check_scale(1., 32767);
	errs += check_scale(2., 32767);
	errs += check_scale(-2., -32768);
	errs += check_scale(0.1, 3277);
	errs += check_scale(-0.1, -3277);

	// Fill with values... every possible 16 bit number.
	for(int i=0; i<count; ++i)
	{
		inbuf[i] = (int16_t)(i + start);
		outbuf[i] = -1;
	}
	fprintf(stderr, "first: %i / %i\n", inbuf[0], outbuf[0]);
	fprintf(stderr, "last:  %i / %i\n", inbuf[count-1], outbuf[count-1]);

	audio::clip_init(0);

	// Encode from/to the same type, yielding clipping as the only effect.
	audio::encode_from(audio::signed_16_i, inbuf, count*2, mixbuf, 1, samples);
	audio::encode_to(audio::signed_16_i, mixbuf, 1, samples, outbuf, bytes);

	fprintf(stderr, "first: %i / %i\n", inbuf[0], outbuf[0]);
	fprintf(stderr, "last:  %i / %i\n", inbuf[count-1], outbuf[count-1]);

	if(bytes != count*2)
	{
		fprintf(stderr, "Something fishy with byte count.\n");
		++errs;
	}
	else
	{
		for(int i=0; i<count; ++i)
		{
			if(inbuf[i] != outbuf[i])
			{
				fprintf(stderr, "Sample %i is wrong: %i vs. %i .\n", i, inbuf[i], outbuf[i]);
				++errs;
				break;
			}
		}
	}

	printf("%s\n", errs == 0 ? "PASS" : "FAIL");
	return 0;
}

int check_scale(float scale, int16_t val)
{
	int16_t sample = val+100; // Different for sure.
	audio::scale_to_sample(scale, audio::signed_16, &sample);
	if(sample != val)
	{
		fprintf(stderr, "scale %f wrong (%i != %i)\n", scale, sample, val);
		return 1;
	}
	return 0;
}
