// Test for communication using the action list.
// I am trying to trace down an inconsistency where an input worker
// pushes an action, the mixer gets notified via the semaphore, but
// the action list is empty. Will I succeed?

// The bug got fixed, not really related to this test.
// The test stays, as it excercises the actionlist and threads a bit.

#include "basics.hxx"
#include "threads/threads.hxx"
#include "actionlist.hxx"
#include "threads/semaphore.hxx"
#include "secsleep.hxx"

#include <vector>

#include "shortcuts.hxx"
#include "debug.hxx"

using namespace dmd;
using std::vector;


static const dmd::api::def dummy_action_def =
{ dmd::api::NOTHING, "<internal dummy>", "This is none of your business.", 0,
	{ },
	{ },
	0
};


class input_worker: public thread
{
	public:
	input_worker(actionlist &mixact): thread("input_worker"), mixer_actions(&mixact) {};
	~input_worker(){};
	void thread_work()
	{
		while(sem.wait(this))
		{
			secsleep(0.1);
			fprintf(stderr, "worker %p pushing an action to %p\n", this, mixer_actions);
			action *dispo = new action();
			dispo->def = &dummy_action_def;
			dispo->disposable = true;
			mixer_actions->push(dispo);
			fprintf(stderr, "worker %p done pushing action %p\n", this, dispo);
		}
	};

	semaphore sem;

	private:
	actionlist *mixer_actions;
};

const int threadcount = 4;
const int perthread = 3;

void process_actions(vector<action*> acts)
{
	FOR_VECTOR(action*, acts, a)
	{
		action *act = *a;
		if(act->disposable)
		{
			fprintf(stderr, "disposing of action %p (%s)\n", act, act->def->name);
			delete act;
		}
	}
}

int main(int argc, char **argv)
{
	bool good = true;
	thread_container workers;
	actionlist actions;
	for(int i=0; i<threadcount; ++i)
	{
		workers.create_thread(new input_worker(actions));
	}

	int act_count = 0;
	workers.threads_lock.lock();
	for(int i=0; i<threadcount; ++i)
	{
		for(int j=0; j<perthread; ++j)
		{
			((input_worker*)(workers.threads[i]))->sem.post();
			++act_count;
		}
	}
	workers.threads_lock.unlock();
	while(act_count > 0)
	{
		fprintf(stderr, "got action on %p?\n", &actions);
		
		if(actions.got_work())
		{
			actions.pulling();
			act_count -= actions.get_list().size();
			MDEBUG("[mixer] executing actions %p (size: %zu)", &actions, actions.get_list().size());
if(actions.get_list().size() < 1)
{
	SERROR("[mixer] Why I am here? Somebody woke me but there are no actions! This is breakage in the program.");
	actions.done_pulling();
	good = false;
	break;
}
			process_actions(actions.get_list());
			SDEBUG("[mixer] actions done");
			actions.done_pulling();
			SDEBUG("[mixer] lock released");
		}
		secsleep(0.001);
	}

	workers.erase_threads();
	printf("%s\n", good ? "PASS" : "FAIL");
	return good ? 0 : -1;
}
