#ifndef DMD_H_H_TSTRING
#define DMD_H_H_TSTRING
/*
	tstring: Utilities for C++ strings.

	part of DerMixD
	(c)2008-2010 Thomas Orgis, licensed under GPLv2

	This used to be a nifty hack in form of a string class derived from std::string, adding methods for sprintf() and lowercase(). But usefully extension of std::string is limited by the fact that its destructor is not virtual -- you cannot add any cleanup code that works in a polymorphic way.
	With that in mind, it's only unnecessary hassle to have two distinct string classes -- you end up converting between the two in various places, mainly because containers of the string objects (or pointers) are not as interchangeable as the plain strings objects are.
	That would be fixed by forcing use of the derived class everywhere, but that may interfere with interfacing to other code (OK, that's still unlikely, because you cannot build stable libraries with C++).
	But a simpler fix for the inconvienece is simply to take a step back and loose the focus on objection orientation. I want sprintf() that works on std::strings? So I will just write a frikkin' function that does exactly that. No need to invent a new type of string.

	There's some nifty convenience lost via that approach (like, creation of temporaries with sprintf method called on them), but also cruft prevented.
*/

#include <string>

// This appends to the string, via format and variable arguments just like the standard C snprintf().
// Note that this is not efficient, just convenient.
// It extends the string storage as it's needed.
// Return value is false if something went wrong...
bool strprintf(std::string &in, const char *fmt, ...);

// Transform this string to lowercase, additionaly returning reference to it.
// Be aware of this working for ASCII only.
std::string& lowercase(std::string &in);

#endif
