/*
	tstring: Utilities for C++ strings.

	part of DerMixD
	(c)2008-2010 Thomas Orgis, licensed under GPLv2
*/



#include "tstring.hxx"

// I didn't get vsnprintf on Solaris with cstdio and cstdarg:-/
#include <stdio.h>
#include <stdarg.h>

#include <cerrno>
#include <cstdlib>

#include <cerrno>
#include <cstring>
#include <algorithm>

#include "debug.hxx"

using namespace std;

// Chunks for increasing the sprintf buffer.
// On a sane libc, that is not even needed as snprintf will say how big the buffer needs to be.
#define CHUNK 50

bool strprintf(string &in, const char *fmt, ...)
{
	// Quick: Start out on the stack.
	// Only for bigger jobs memory will be allocated on the heap.
	char tsbuf_stack[50];
	char *tsbuf = tsbuf_stack;
	size_t tsbufs = 50;
	int fit = -1;
	do
	{
#ifdef DEBUG
		errno = 0;
#endif
		va_list ap;
		va_start(ap, fmt);
		fit = vsnprintf(tsbuf, tsbufs, fmt, ap);
		va_end(ap);
		if(fit >= (int)tsbufs || fit<0) // fit<0 is for old glibc and whoever.
		{
			tsbufs = fit > -1 ? fit+1 : tsbufs+CHUNK;
			MDEBUG("fit=%i, increasing size to %zu (error: %s)", fit, tsbufs, strerror(errno));
			// The full set of realloc paranoia.
			if(tsbuf == NULL || tsbuf == tsbuf_stack)
			{
				tsbuf = (char*)malloc(tsbufs);
				if(tsbuf == NULL) return false;
			}
			else
			{
				char *tb = (char*)realloc(tsbuf, tsbufs);
				if(tb == NULL) // Should not happen...
				{
					free(tsbuf);
					tsbufs = 0;
					return false;
				}
				tsbuf = tb;
			}
		}
		else break;
	} while(1);
	// Now append the sprintf'ed string.
	in += tsbuf;
	if(tsbuf != tsbuf_stack) free(tsbuf);

	return true;
}

string& lowercase(string &in)
{
	transform(in.begin(), in.end(), in.begin(), ::tolower);
	return in;
}
