#ifndef H_DMD_THREAD_NICENESS
#define H_DMD_THREAD_NICENESS
/*
	Since the behaviour of thread priorities under NPTL is erratic (inheritance of nice level is different in daemon mode compared to interactive terminal mode), here comes a fixed list of thread priorities.

	The numbers are to be interpreted as nice levels: Higher number means lower priority. This is fed to setpriority() on Linux, and would be utilized properly on some sane POSIX thread platform, if I encounter one.
*/

// Quick hack for name conflict (open64).
#define nice nicelevel
namespace dmd {
namespace nice {
enum values
{
	 base = 0
	,signal_handler = 0
	,output_worker = 0
	,output_processor = 1
	,mixer_worker = 4
	,mixer_sink = 6
	,sockets = 5
	,socket_reaper = 7
	,socketeer = 4
	,input = 2
	,input_prebuffer = 3
	,input_background = 10
};

}}



#endif
