#ifndef DMD_H_SEMAPHORE
#define DMD_H_SEMAPHORE

namespace dmd {
class thread;
}

class semaphore
{
	// If anything goes wrong, you are supposed to examine the system error state (errno, or the syserror class, respectively).
	public:
	semaphore();
	~semaphore();
	bool post();
	// Wait until semaphore has some value, decrement it.
	// This also resumes waiting if interrupted by signal handler or whatnot.
	// Only returns false if there is really considered to be fatal failure.
	// If there is a thread provided, it will be made cancelable while waiting for the semaphore.
	bool wait(dmd::thread *ted = NULL);
	// Return true if semaphore has been decremented, false if we would have blocked.
	bool trywait();
	// Get the value of the semaphore (only valid if returning true).
	// Note: This is really the plain value, we do not play games with number of waiting threads or so.
	bool getvalue(int &val);
	// Do whatever it takes to make the semaphore zero for once (wait repeatedly, usually).
	bool zero();

	private:
	struct my_private;
	struct my_private *parts;
};

#endif
