#ifndef DMD_H_READWRITE_BARRIER
#define DMD_H_READWRITE_BARRIER
/*
	readwrite_barrier: A read/write barrier for data structures that need to be accessible to many threads simultaneously for read-only action, but are exclusive for write action.

	part of DerMixD
	(c)2008-9 Thomas Orgis, licensed under GPLv2

	I once had this envisioned as template, then as base class to inherit from... then wondered if that complication is really necessary. Settled for a simple self-contained class that can be a member of the class that needs read/write protection.
	You don't have to do inheritance everywhere just because you can.
*/

#include "mutex.hxx"
#include "threads/semaphore.hxx"

namespace dmd
{

class readwrite_barrier
{
	public:
	 readwrite_barrier();
	~readwrite_barrier();

	// Take hold of the lock for writing, also wait until all readers are gone.
	void writing();
	// Release the lock, so that readers can come up again.
	void done_writing();
	// Notify that one is going to read. After that returns, no write action shall happen until ...
	void reading();
	// ... all readers called this one to signal that they are done.
	void done_reading();

	private:
	// A lock for exclusivity.
	real_mutex lock;
	// Basically a safe counter for the number of threads that are reading.
	semaphore readers;
};

// Yeah, if this would be API for other folks to use, I'd use less metaphoric
// names. I'm doing this for fun, so let me have some cheap fun.

// RAII for reading.
class scholar
{
	public:
	scholar(readwrite_barrier &the_wall): wall(&the_wall) { wall->reading(); };
	~scholar() { wall->done_reading(); };

	private:
	readwrite_barrier *wall;
};

// RAII for writing.
class scribe
{
	public:
	scribe(readwrite_barrier &the_wall): wall(&the_wall) { wall->writing(); };
	~scribe() { wall->done_writing(); };

	private:
	readwrite_barrier *wall;
};

}

#endif
