/*
	readwrite_barrier: A read/write barrier for data structures that need to be accessible to many threads simultaneously for read-only action, but are exclusive for write action.

	part of DerMixD
	(c)2008-9 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "threads/readwrite_barrier.hxx"
#include "scheduling.hxx"

#include "debug.hxx"
#define ME "readwrite_barrier"

namespace dmd
{

readwrite_barrier::readwrite_barrier()
{
	CONSTRUCT(ME);
}

readwrite_barrier::~readwrite_barrier()
{
	DESTBEGIN(ME);
	DESTEND(ME);
}

void readwrite_barrier::reading()
{
	lock.lock();
	readers.post();
	lock.unlock();
}

void readwrite_barrier::done_reading()
{
	readers.wait();
}

void readwrite_barrier::writing()
{
	SDEBUG("going to lock and wait until all readers are gone");
	lock.lock();
	// So what... nasty busy waiting, trying to cover that with sched_yields().
	// We do wait attempts until the semaphore is zero; all readers are gone.
	// This is not pretty... safer would be adding some millisecond sleep or such; but that's nasty again.
	// Calling sched_yield() will eventually work for reader threads with at least same priority as the writer.
	// But, well... if the writer thread is the top-dog of scheduling, it will be busy decrementing/incrementing that semaphore by itself all the time:-/
	// I guess there are "proper" implementations of read/write barriers out there... one might want to have a look.
	while(readers.trywait())
	{
		SDEBUG("Still readers there, reposting and giving readers a chance to touch the semaphore.");
		readers.post();
		dmd::let_others_work();
	}
	SDEBUG("can write now");
}

void readwrite_barrier::done_writing()
{
	SDEBUG("done writing");
	lock.unlock();
}

}
