#ifndef DMD_H_TEXTREAD
#define DMD_H_TEXTREAD
/*
	textread: C-ish code to read lines from text files (or stdin).

	part of DerMixD
	(c)2010 Thomas Orgis, licensed under GPLv2

	This stuff has been extracted from the param class' implementation (parsing of config files). Yes, I could do it more object-oriented... basically coding what C++ streams do. But sometimes I like my plain functions and plain old data.
*/

namespace dmd
{
	// That reads a line from the intput file into the given buffer.
	// The buffer is resized as needed and the new size stored in the corresponding parameter (which really should contain the old size of the buffer for the call).
	// Usually, you start with NULL and 0 and getline handles all memory allocation itself -- you only need to free the output buffer when being done with it,
	// Return value of this is the current count of bytes read into a line (including line break and null byte), or 0 on error or end of file.
	size_t getline(FILE* in, char* &line, size_t &size);

	// Remove any line end markers (\n or \r) by making them zero bytes.
	// If provided string length is zero, strlen() is used.
	void chomp(char *line, size_t lenght = 0);
}

#endif
