/*
	textread: C-ish code to read lines from text files (or stdin).

	part of DerMixD
	(c)2010 Thomas Orgis, licensed under GPLv2

	Note: This code is largely lifted from the param class (config file parsing).
*/

#include "basics.hxx"
#include <stdio.h>
#include <string.h>

#include "debug.hxx"

using namespace std;

namespace dmd
{

// Get a line from the specified file.
// This mimics functionality given elsewhere... note the use of fgets... we rely on native interpretation of \n here ... but still use \r for some ad-hoc compatibility with DOS files.
size_t getline(FILE *in, char *&out, size_t &size)
{
	if(size == 0 || out==NULL)
	{
		size = 10;
		out = (char*)malloc(size); // Increase that later.
		if(out == NULL)
		{
			SERROR("D'OOM!");
			return 0;
		}
	}
	size_t fill = 0; // length of the string, without \0
	while(1)
	{
		MDEBUG("size %zu, fill %zu\n", size, fill);
		if(fgets(out+fill, size-fill, in) == NULL)
		return fill;

		fill = strlen(out);
		MDEBUG("read (partial) line of length %zu: %s\n", fill, out);

		// Check if we really got a line or need to increase the buffer and continue.
		// The last byte is always \0, before that we want a \n or \r.
		if(out[fill-1] == '\n' || out[fill-1] == '\r') // a half \r\n sequence could be there...
		return fill;

		SDEBUG("Line not fully there, increasing buffer.");
		// Else, realloc to get more data in.
		if(size > ((unsigned int)-1)/4)
		{
			SERROR("Maximum line length reached!");
			return 0;
		}
		char *tmp = (char*)realloc(out, 2*size);
		if(tmp == NULL){	SERROR("D'OOM!"); return 0; }

		out = tmp;
		size *= 2;
	}
}

// Cut off the line end...
void chomp(char *line, size_t length)
{
	if(length == 0) length = strlen(line);

	if(length < 1) return;

	MDEBUG("length=%zu", length);

	size_t pos = length-1;
	// Handle the end zero byte being included in the length.
	// Skip it, including detection of empty string.
	if(line[pos] == 0)
	{
		if(pos > 0) --pos;
		else return;
	}

	// Now chop off any line end markers until a non-marker is found, or we are at the beginnig of the line.
	do
	{
		MDEBUG("Checking pos %zu (%i).", pos, (int)line[pos]);
		if(line[pos] == '\n' || line[pos] == '\r') line[pos] = 0;
		else return;

		if(pos > 0) --pos;
	} while(pos > 0);
}

}
