#ifndef DMD_H_SYSERROR
#define DMD_H_SYSERROR
/*
	syserror: Safely retrieve an error string for system errors. Multithreading style.

	part of DerMixD
	(c)2009 Thomas Orgis, licensed under GPLv2

	The point of it all: strerror() is not thread-safe. You need to provide some storage to strerror_r() instead.
	So we wrap that storate into a class that can allocate it dynamically and also cleans up in the end.
*/

#include <sys/types.h>

class syserror
{
	private:
	char* buf;
	size_t bufsize;
	const char* get_errtext(int errcode);

	public:
	// The constructor does _not_ clear error state (errno).
	// If you want to be fresh, call clear() explicitly.
	syserror();
	~syserror();
	// Fetch error string and return pointer to buffer.
	// It is guaranteed to be some null-terminated string.
	const char* str(); // That uses errno.
	const char* str(int errcode);
	bool problem(); // Examine the syste error state if there's a problem (errno != 0).
	void clear(); // Clear error state (errno = 0).
};

#endif
