/*
	single: central init/exit code to be run in non-multithreaded state

	part of DerMixD
	(c)2008-2011 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "audio/audio_format.hxx"

#ifdef EFFECT_LADSPA
#include "audio/effect/ladspa.hxx"
#endif
#include "param_init.hxx"

#include "debug.hxx"

int single_init()
{
	int ret = 0;
	// The audio conversion engine needs to be initialized once, the clipping part of which.
	audio::clip_init(param.as_float("clip_width"));
#ifdef EFFECT_LADSPA
	// Build the list of ladspa plugin directories.
	// DerMixD will only accept library files in those, for security reasons.
	dmd::effect::ladspa_init();
#endif
	return ret;
}

void single_exit()
{
}
