#include "basics.hxx"
#include "threads/threads.hxx"
#include "coms/client_action_handler.hxx"

#include "debug.hxx"

static bool running = false;
// Signal mask for the handler thread, taken from calling (main) thread, restored on exit.
sigset_t mask;


namespace dmd {
namespace sigfried {

int fatal_signal = 0;

class handler: public thread
{
	private:
	client_action_handler* actor;

	public:
	 handler(): thread("signal handler", nice::signal_handler), actor(NULL) { CONSTRUCT("handler"); }
	~handler(){ DESTRUCT("handler"); }

	void thread_work()
	{
		int signum;
		sigset_t siglist;
		sigemptyset(&siglist);
		// For now mainly watching for signals that trigger graceful termination.
		// You could add any user signals... pausing of all channels, closing of all outputs ...
		sigaddset(&siglist, SIGINT);
		sigaddset(&siglist, SIGTERM);
		// That's ignored, basically.
		sigaddset(&siglist, SIGPIPE);

		dmd::threads::block_signals(&siglist);
		thread_cancelable(true);
		while(dmd::threads::wait_for_signal(&siglist, &signum))
		{
			thread_cancelable(false);
			{
				fprintf(stderr, "Got signal: %i\n", signum);
				switch(signum)
				{
					case SIGINT:
					case SIGTERM:
						fatal_signal = signum;
						if(actor) actor->handle("shutdown");
					break;
					case SIGPIPE:
						fprintf(stderr, "Duh, a pipe broke. Call a plumber!\n");
					break;
					default:
					fprintf(stderr, "Ignoring this one.\n");
				}
			}
			thread_cancelable(true);
		}

		SERROR("Signal handler stumbled!");
	}

	// You are responsible to always call both of these!

	bool start(actionlist &actions)
	{
		actor = new client_action_handler(*this, actions);
		return thread_create();
	}

	void stop()
	{
		thread_kill();
		delete actor;
		actor = NULL;
	}
};

static handler handy;

void start(actionlist &actions)
{
	if(running) return;
	// fetch the current mask
	dmd::threads::block_signals(NULL, &mask);
	handy.start(actions);
	running = true;
}

void stop()
{
	if(running)
	{
		handy.stop();
		dmd::threads::block_signals(&mask);
		running = false;
	}
}

size_t thread_info(std::vector<std::string*> &tl)
{
	handy.thread_add_info(tl);
	return 1;
}

}}
