/*
	safelocale: ensure safe (C) locale

	part of DerMixD
	(c)2009-2011 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "safelocale.hxx"
#include <locale.h>

locale_env::locale_env()
{
	// A more careful route, not just setting C locale once here, but also ensure that the environment points to the C locale.
	// There are random pieces of (library) code that like to do setlocale(LC_ALL, "").
	setenv("LC_ALL", "C", 1);
	char *loc = setlocale(LC_ALL, "");
	/* fprintf(stderr, "Set safe locale: %s\n", loc ? loc : "NULL"); */
}
locale_env::~locale_env(){}

locale_env localizer;
