#ifndef DMD_H_PEERS
#define DMD_H_PEERS
/*
	peers: list of communicators that are available for peer2peer communication.

	part of DerMixD
	(c)2008-9 Thomas Orgis, licensed under GPLv2
*/

#include "action.hxx"
#include "coms/socket_writer.hxx"
#include "threads/readwrite_barrier.hxx"

#include <string>
#include <vector>

class one_peer
{
	public:
	dmd::socket_writer* swr;
	std::string name;
	std::string description;
};

class peers
{
	private:
	dmd::readwrite_barrier barrier;
	std::vector<one_peer> them;

	public:
	peers();
	~peers();
	// Send a message... failing when there is no peer of that name.
	bool message(action &act);
	// List all peers.
	void list(std::vector<std::string*> &listing); 
	// Add a new entry, error if name already taken.
	bool add(dmd::socket_writer* swr, const std::string &name, const std::string &descr);
	// Remove one entry...
	bool remove(const std::string &name);
	// Remove all peer entries for that socket
	void eliminate(dmd::socket_writer* swr);
	void eliminate_all(); // ...
};

#endif
