/*
	peers: list of communicators that are available for peer2peer communication.

	part of DerMixD
	(c)2008 Thomas Orgis, licensed under GPLv2
*/
#include "common.hxx"
#include "peers.hxx"
#include "coms/socket_writer.hxx"

#include "debug.hxx"

#define ME "peers"

using std::vector;
using std::string;

peers::peers()
{
	CONSTRUCT(ME);
}

peers::~peers()
{
	DESTBEGIN(ME);
	DESTEND(ME);
}

bool peers::message(action &act)
{
	bool ret = false;
	barrier.reading();
	for(vector<one_peer>::iterator s = them.begin(); s != them.end(); ++s)
	if(s->name == act.strings[1])
	{
		string* ms = new string;
		act.msg(act.strings[2], *ms);
		s->swr->write(ms);
		ret=true;
		break;
	}
	barrier.done_reading();
	return ret;
}

void peers::list(vector<string*> &listing)
{
	barrier.reading();
	for(vector<one_peer>::iterator s = them.begin(); s != them.end(); ++s)
	{
		listing.push_back(new string("\t"));
		*listing.back() += s->name;
		*listing.back() += "\t";
		*listing.back() += s->description;
	}
	barrier.done_reading();
}

bool peers::add(dmd::socket_writer* peer, const string &name, const string &descr)
{
	vector<one_peer>::iterator i;
	barrier.reading();
	/* Look if name already taken. */
	for(i=them.begin(); i!=them.end(); ++i)
	if(i->name == name) break;
	barrier.done_reading();

	if(i == them.end())
	{
		barrier.writing();
		them.push_back(one_peer());
		them.back().swr = peer;
		them.back().name = name;
		them.back().description = descr;
		barrier.done_writing();
		return true;
	}
	else return false;
}

bool peers::remove(const string &name)
{
	bool ret = false;
	barrier.writing();
	for(vector<one_peer>::iterator i=them.begin(); i!=them.end(); ++i)
	if(i->name == name)
	{
		them.erase(i);
		ret = true;
		break;
	}
	barrier.done_writing();
	return ret;
}

void peers::eliminate(dmd::socket_writer *swr)
{
	vector<one_peer>::iterator i;
	barrier.writing();
	/* Trying to delete _multiple_ occurences in a vector... */
	i = them.begin();
	while(i!=them.end())
	{
		if(i->swr == swr) i = them.erase(i);
		else ++i;
	}
	barrier.done_writing();
}

void peers::eliminate_all()
{
	barrier.writing();
	them.clear();
	barrier.done_writing();
}
