#ifndef DMD_H_PARSENUM
#define DMD_H_PARSENUM
/*
	parsenum: simple parsing of strings to numbers of specific type.

	part of DerMixD
	(c)2009 Thomas Orgis, licensed under GPLv2

	We use base 10 number format (i.e. decimal) only. Also, parsing happens using C locale, so no fancy localized stuff (whatever could there be in an integer).
*/

#include <sys/types.h>
#include <string>

// These assume that the whole string consists of the number.
// Actually, we stop at invalid characters, but the idea is to tokenize strings before calling these functions.
enum strnum_err
{
	 strnum_good = 0 // All fine.
	,strnum_overflow // Value too large / small to be represented.
	,strnum_invalid  // String did not start with valid number characters.
};

// These are the slow but flexible variants using STL strings
// char* is usable as initializer.
// One might overload these functions with const char* for efficiency.
int    str_to_int(const std::string s, int &err);
long   str_to_long(const std::string s, int &err);
size_t str_to_size(const std::string s, int &err);
off_t  str_to_offset(const std::string s, int &err);

// OK, here we go... not for efficiency, just for lazyness.
// With the pointer argument, you can omit the error value retrieval, as simple replacement for atoi(), for example.
int    str_to_int(const std::string s, int *err = NULL);
long   str_to_long(const std::string s, int *err = NULL);
size_t str_to_size(const std::string s, int *err = NULL);
off_t  str_to_offset(const std::string s, int *err = NULL);

extern const int int_min;
extern const int int_max;
extern const long long_min;
extern const long long_max;
extern const off_t off_t_min;
extern const off_t off_t_max;
extern const size_t size_t_max;

#endif
