/*
	param_init: initialization of the parameters
	
	part of DerMixD
	(c)2005-2014 Thomas Orgis, licensed under GPLv2
*/

#include "common.hxx"
#include "param_init.hxx"

#ifndef DEFAULT_BUFFER_SAMPLES
	#ifdef OUT_MME
		//my XP1000 does easily stutter with (just) double buffering
		#define DEFAULT_BUFFER_SAMPLES "4096"
	#else
		//bit more responsive default for Linux... just enough for my 366MHz PII laptop
		#define DEFAULT_BUFFER_SAMPLES "1024"
	#endif
#endif
#ifdef OUT_ALSA
	#define DEFOUT "alsa"
	#define DEFOFILE "default"
#else
	#ifdef OUT_OSS
		#define DEFOUT "oss"
		#define DEFOFILE "/dev/dsp"
	#else
		#ifdef OUT_MME
			#define DEFOUT "mme"
			#define DEFOFILE "nothing special"
		#else
			#define DEFOUT "dummy"
			#define DEFOFILE "I don't care!"
		#endif
	#endif
#endif

static const char *pardef[] =
{
	 "main", "tcp",  "yes", "listen on a TCP port"
	,"main", "unix", "yes", "listen on UNIX domain socket"
	,"main", "socket", "/tmp/dermixd.socket", "UNIX domain socket path"
	,"main", "port", "8888", "specify the TCP port to use"
	,"main", "daemon", "yes", "Go into the background as daemon."
	,"main", "remote", "no", "Allow connections from the outside. Default is to only accept connections from localhost. Consider that there is no authorization checking for clients, be it local or remote (so, at least  every user on your machine can talk to me)!"
	,"main", "defsetup", "yes", "Start with default setup of input/output channels."
	,"main", "version", "no", "Show version info."
	,"main", "api", "no", "Print out the dermixd client API."

	,"main", "buffer", DEFAULT_BUFFER_SAMPLES, "mixer buffer size in samples"
	,"main", "audio_rate", "44100", "mixer and output sample rate"
	,"main", "channels", "2", "channels for mixer and all outputs (1 for mono or 2 for stereo)"
	// Note: That covers stderr messages... there should be no output on stdout anyway.
	,"main", "output", "/dev/null", "in daemon mode messages get redirected to that file"
	,"main", "default_output", DEFOUT, "default output device class to use in standard setup"
	,"main", "default_outfile", DEFOFILE, "default file for default output..."
	,"main", "clip_width", "0.0234", "Relative width of soft clipping range (0..1), if zero, hard clipping is employed."

	,"input","prebuffer","10","input prebuffer size in seconds (based on mixer samplerate)"
	,"input","zeroscan", "off", "on/off the facility to remove zero padding and beginning and end of tracks (helps gapless transitions)"
	,"input","zerolevel", "0.01", "the amplitude level (relative to full scale, linear) that is just not considered zero anymore when removing padding - you may want to avoid some dirt..."
	,"input","zerorange", "5", "specify range to scan for leading/trailing silence in seconds"

#ifdef IN_LIBMPG123
	,"mpg123", "decoder", "", "the decoder (optimization) variant to use ... empty value triggers auto detection"
	,"mpg123", "rva", "mix", "apply RVA preamp according to values stored in MPEG files (choose: mix, album or empty string for none)"
	,"mpg123", "resync_limit", "-1", "limit search for valid MPEG data (if >= 0, that many bytes are examined)"
#endif
	,"output", "buffers", "3", "How many buffers to employ for output multibuffering."
#ifdef OUT_ALSA
	,"alsa","buffer","0.1","alsa buffer size in seconds"
#endif
#ifdef EFFECT_LADSPA
	,"effect","ladspa_path","","Search paths for LADSPA plugin libraries, colon-separated (if empty, the environment variable LADSPA_PATH is used)."
#endif
	,NULL
};

// I am curious ... where is the constructor code run?
param_space param(pardef);
