#ifndef DMD_H_PARAM
#define DMD_H_PARAM

/*
	param: some parameters in the environment...
	
	part of DerMixD
	(c)2005-2012 Thomas Orgis, licensed MIT-style
	
	I want Perl's hashes... implement it via stupid search now an do something better when configuration space gets bigger.
	Of course one should use a nice library for that - but I won't introduce a dependency for more than C++ STL and pthreads without good reason!
	
	For now I have here a class representing a parameter space of strings organized in groups (so, essentially two-dimensional).
	This is loosely bound to command line arguments or possibly config files via a parse method that just interprets "group.name=value".
	
	You can retrieve a copy of the current string value of a parameter or an interpreted bool, usigned int or unsigned long int value.
*/

#include <string>
#include <vector>
#include <map>
#include <stdio.h>
#ifdef PARAM_MULTITHREAD
// DerMixD wants multithreaded access, so it provides mutex types for that.
#include "mutex.hxx"
#endif

// Namespacse suck... why can't I just wring using std::string inside the class?
// Of course... these macros are dangerous in case string and vector are macros themselves... but the preprocessor will error out then early.
#define string std::string
#define vector std::vector

class parm
{
	public:
	string name;
	string value;
	string help;
	
	parm();
	parm(const string &n, const string &v, const string &h);
	~parm();
};

class parm_group
{

	public:
	
	string name;
	vector<parm*> parms;
		
	parm_group(const string &n);
	~parm_group();
	parm* get(const string &n);
};

class param_space
{
	private:
		vector<parm_group*> pgv;
		std::map<string, string> shortcuts;
		size_t maxlen, maxshort;
		parm_group* get_group(const string name);
		string dummy; // for retrieval of non-existing strings per reference 
		int get_parm_struct(const string group, const string name, parm* &pmp);
#ifdef PARAM_MULTITHREAD
		// locked mode only for high level methods
		optional_mutex the_lock;
#endif
		void lock();
		void unlock();
		void prepare(); // Pre-constructor.

	public:
		param_space();
		// Construct and define groups.
		param_space(const char **pardef);
		virtual ~param_space();
		string separator; // "--" per default
		string program; // name of the progam... argv[0]
		string usage; // extra usage info for help()

		//return true on success (specified parameter found)
		bool get(const string group, const string name, string& value);
		bool set(const string group, const string name, const string value);
		// cannot give default value to first argument
		bool get(const string name, string& value){ return get("main", name, value); };
		bool set(const string name, const string value){ return set("main", name, value); };
		bool parse(const string arg);
		// parse_program: put argv[0] into program string
		bool parse(int &argc, char **&argv, const bool parse_program = true);

		//should always succeed
		void define(const string group, const string name, const string value, const string help); //define a new parameter
		void define(const string name, const string value, const string help)
		{
			define("main", name, value, help);
		};
		// define a list of parameters in one group
		// pardef = { "name", "value", "help", "name", "value", "help", NULL }
		void define(const char **pardef, const string group = "main");
		// define a list of parameters in different groups
		// pardef = { "group", "name", "value", "help", "group", "name", "value", "help", NULL }
		void define_groups(const char **pardef); // define a set of groups in one go
		void help(FILE* out = stdout); //print parameter space with parameter help in textual form
		// Define shortcuts: input string and expansion, example for builtin help:
		//  shortcut("-h", "help=1");
		//  shortcut("--help", "help=1");
		void shortcut(const string short_one, const string long_one);

		bool read(FILE *in = stdin);
		bool write(FILE *out = stdout);
		// direct access
		string& val(const string group, const string name);
		string& val(const string name){ return val("main", name); }
		string& operator()(const string name){ return val("main", name); }
		string& operator()(const string group, const string name){ return val(group, name); }

		//converters, return converted value
		bool as_bool(const string group, const string name);
		bool as_bool(const string name){ return as_bool("main", name); };
		int as_int(const string group, const string name);
		int as_int(const string name){ return as_int("main", name); };
		long int as_lint(const string group, const string name);
		long int as_lint(const string name){ return as_int("main", name); };
		double as_double(const string group, const string name);
		double as_double(const string name){ return as_double("main", name); };
		float as_float(const string group, const string name){ return (float)as_double(group, name); };
		float as_float(const string name){ return (float)as_double("main", name); };
		unsigned int as_uint(const string group, const string name);
		unsigned int as_uint(const string name){ return as_uint("main", name); };
		unsigned long int as_ulint(const string group, const string name);
		unsigned long int as_ulint(const string name){ return as_ulint("main", name); };
		size_t as_size(const string group, const string name);
		size_t as_size(const string name){ return as_size("main", name); };
		const char *c_str(const string group, const string name);
		const char *c_str(const string name){ return c_str("main", name); };

		// tests
		bool is_equal(const string group, const string name, const string value);
		bool is_equal(const string name, const string value){ return is_equal("main", name, value); };
		// Those are stubs in non-multithreaded build.
		// enable/disable multithreaded access to parameters
		// when single is called, nobody should be busy with param space!
		bool concurrent();
		void single();
};

// It's there, so offer it:
// Working like the GNU extension getline(), this reads text lines from given input. A line ends when fgets() thinks it does.
// You are supposed to hand in the current size of the buffer, which will be updated if the buffer needed enlargement.
size_t param_getline(FILE *in, char *&out, size_t &size);

#undef string
#undef vector

#endif
