#ifndef DMD_H_OUTCHANNEL
#define DMD_H_OUTCHANNEL
/*
	outchannel: mixer output channels

	part of DerMixD
	(c)2004-2010 Thomas Orgis, licensed under GPLv2
*/

#include "channel.hxx"
#include "out/output_state.hxx"
#include "out/output_worker.hxx"
#include "out/output_processor.hxx"
#include "mixing_buffer.hxx"

#include <string>
#include <vector>

namespace dmd {

class outchannel: public channel
{
	private:

	// The work thread, wrapping over the actual output device.
	// It also wraps over a chain of buffers for multibuffering.
	dmd::output_worker worker;
	// A single-purpose thread for converting mixer buffers to the output format.
	dmd::output_processor procor;

	// void nodev();

	public:

	output_state state;
	mixing_buffer buffer;
	std::vector<inchannel*> sources;

	outchannel(size_t id, const std::string& name, semaphore &playsem, dmd::actionlist &mixact);
	~outchannel();

	// Move the finished buffer towards the output.
	// This also changes outchannel::buffer to point to the next free buffer to mix into.
	void play();

	void sync_state();
	void statline(std::string &ts); // Print status line to ts.
	void now_and_then(size_t chunksize, float &now, float &then);

	// bool device_sane();
	void set_id(size_t newid);
	// Manage input channel connection.
	void bind(inchannel* inch); // Bind to input.
	void unbind(inchannel *inch); // Release the bond.

	// Handle a given action concerning this channel.
	// That includes notification.
	void handle_action(action *act);
};

}
#endif
