#ifndef DMD_H_OUTPUT_WORKER
#define DMD_H_OUTPUT_WORKER
/*
	output_worker: The actual work happening for output channels, in a thread.

	part of DerMixD
	(c)2010 Thomas Orgis, licensed under GPLv2
*/

#include "out/output_state.hxx"
#include "threads/threads.hxx"
#include "action_queue.hxx"
#include "out/output_file.hxx"
#include "audio/audio_bufferpool.hxx"
#include "actionlist.hxx"

namespace dmd
{

class output_worker: public thread
{
	private:
	output_file *outfile;
	action_queue worklist;
	audio_bufferpool pool;

	void do_play();
	void do_open(action *act);
	void do_close(action *act);
	void do_nodev(action *act);

	public:
	output_state state;
	dmd::actionlist *mixer_actions;

	 output_worker(dmd::actionlist &mixact);
	~output_worker();

	// The play action doesn't need any back communication.
	// It takes over the given buffer and hands it to the writer thread.
	void play(audio_buffer *buf);
	// After play(), use the method to get the next buffer to mix into.
	// You could grab multiple buffers in a row, even.
	audio_buffer* next_buffer();
	// Other operations use an action argument for parameters and return message path.
	void load(action *act);
	void eject(action *act);
	void nodev(action *act);

	void thread_work();
	void work_process_action(action *);
};

}
#endif
