#ifndef DMD_H_OUTPUT_STATE
#define DMD_H_OUTPUT_STATE

/*
	output_state: State of an output channel, communicated across threads.
	
	part of DerMixD
	(c)2004-2010 Thomas Orgis, licensed under GPLv2
*/

#include "audio/audio_format.hxx"
#include "mutex.hxx"

#include "out/output_file_types.hxx"

#include <sys/types.h>
#include <string>

// The output channel has one copy of the state, the output worker another one.
// Reason: The background worker thread can mess with its copy, the mixer with the one in the channel.
// At opportune times, the mixer can sync its copy, secured with a mutex.
class output_state: public optional_mutex
{
	public:

	output::type_id type; // of underlying output file.
	std::string filename; // Stored filename for reference.
	audio_format format; // Format is fixed to mixer format, but might be different in future.
	off_t position; // Output position counter might be interesting as runtime measurement.
	bool live; // If this output type is a live sink (needs to be kept playing with silence when nothing happens).

	// Initialize with a mutex to enable locking, or not.
	 output_state(mutex * locker = NULL);
	~output_state();
	// Import state from some source, ensuring action by locking both sides.
	// (Usually, only the source will actually contain a mutex).
	// Meaning of position_offset: A number of samples not to count yet into the position of _this_ state. In other words: It's an offset in positions between the two states.
	void sync(output_state &source, off_t position_offset=0);
	// Clear everything except the type.
	void nofile();
	// A new file has been loaded, possibly.
	// The format is fixed... so only type and file name may change.
	void newfile(output::type_id ntype=output::invalid, const std::string name="");
	// Update the position.
	void increment_position(off_t pos);
};

#endif
