/*
	output_state: State of an output channel, communicated across threads.
	
	part of DerMixD
	(c)2009-2010 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "out/output_state.hxx"
#include "param_init.hxx"

output_state::output_state(mutex *locker):
	optional_mutex(locker), type(output::invalid), position(0), live(false)
{
	// Format is fixed to mixer parameters.
	format.rate = param.as_ulint("audio_rate");
	format.channels = param.as_uint("channels");
}

output_state::~output_state(){}

void output_state::sync(output_state &source, off_t position_offset)
{
	lock();
	source.lock();

	type     = source.type;
	filename = source.filename;
	position = source.position - position_offset;
	format   = source.format;
	live     = source.live;

	source.unlock();
	unlock();
}

void output_state::nofile()
{
	lock();
	filename = "";
	position = 0;
	unlock();
}

void output_state::newfile(output::type_id ntype, const std::string name)
{
	lock();
	position = 0;
	filename = "";
	type = ntype;
	live = output::live_feed(ntype);
	filename = name;
	unlock();
}

void output_state::increment_position(off_t pos)
{
	lock();
	position += pos;
	unlock();
}
