#ifndef DMD_H_OUTPUT_PROCESSOR
#define DMD_H_OUTPUT_PROCESSOR
/*
	output_processor: Convert mixer buffer to output format, do any processing needed before plain output.

	part of DerMixD
	(c)2010 Thomas Orgis, licensed under GPLv2

	The "any processing" could include funky effects.
*/

#include "audio/audio_buffer.hxx"
#include "mixing_buffer.hxx"
#include "out/output_worker.hxx"
#include "threads/threads.hxx"

namespace dmd
{

class output_processor: public thread
{
	private:
	// Need a direct link to the worker to insert/extract buffers.
	// Same for buffer and semaphore... don't wanna hand that over to the thread every time.
	output_worker *worker;
	mixing_buffer *mixbuf;
	// Workaround for the synchronization issue I face.
	semaphore *playsem;
	// The internal semaphore for the thread.
	semaphore worksign;

	public:
	 output_processor(output_worker &worker, mixing_buffer &mixbuf, semaphore &playsem);
	~output_processor();
	// Mix down the given buffer and hand the result to the output worker.
	// After that is done, signal on the semaphore.
	void cycle();

	// A loop for processing ... waiting on the internal semaphore.
	void thread_work();

	private:
	void work_play();
};

}
#endif
