/*
	output_processor: Convert mixer buffer to output format, do any processing needed before plain output.

	part of DerMixD
	(c)2010 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "out/output_processor.hxx"

#include "debug.hxx"

namespace dmd
{

output_processor::output_processor(output_worker &worker_, mixing_buffer &mixbuf_, semaphore &playsem_):
	thread("output_processor", nice::output_processor) ,worker(&worker_), mixbuf(&mixbuf_), playsem(&playsem_)
{
	CONSTRUCT("output_processor");
}

output_processor::~output_processor()
{
	DESTRUCT("output_processor");
}

void output_processor::cycle()
{
	//worksign.post();
	work_play();
}

void output_processor::thread_work()
{
	MDEBUG("[output_processor %p] startup", this);
	while(1)
	{
		if(!worksign.wait(this)) continue;

		work_play();
	}
}

void output_processor::work_play()
{
	audio_buffer *outbuffer = worker->next_buffer();
	if(outbuffer != NULL)
	{
		MXDEBUG("[output_processor %p] mixing down to %p.", this, outbuffer);
		// Future: Apply effects to mixing buffer.
		// Convert mixing buffer to outbuffer format.
		mixbuf->mix_down(outbuffer);
		// Append to output buffer chain.
		worker->play(outbuffer);
		// The worker takes care of the buffer now.
	}
	else
	{
		MERROR("[output_processor %p] got NULL buffer!", this);
	}
	playsem->post();
}

}
