#include "basics.hxx"

#include "out/output_file_types.hxx"
#include "tstring.hxx"

#include <string>

#include "debug.hxx"

using std::string;

// Creators for output files.
#include "blocks/output_factory.hxx"

// The actual code, in with hidden redundancy.

namespace output
{
	const char* names[count] =
	{
		#define X(a,b,c,d) b
		#include "blocks/output_types.hxx"
		#undef X
	};
	const char* invalid_name = "invalid";

	#include "blocks/enummap.hxx"

	// In the future, the type will be part of the namespace
	#define FILE_TYPE output_file

	typedef FILE_TYPE* (*new_file_func)();
	// Remember to keep the proper order...
	static new_file_func creator[count] =
	{
		#define X(a,b,c,d) c
		#include "blocks/output_types.hxx"
		#undef X
	};
	#include "blocks/file_switch.hxx"
	#undef FILE_TYPE

	static const bool live_feed_prop[count] =
	{
		#define X(a,b,c,d) d
		#include "blocks/output_types.hxx"
		#undef X
	};
	bool live_feed(type_id id)
	{
		if(id == invalid) return false;
		else return live_feed_prop[id];
	}

}
