#ifndef DMD_H_OUTPUT_FILE
#define DMD_H_OUTPUT_FILE
/*
	output_file: interface class for output files
	
	part of DerMixD
	(c)2009-2010 Thomas Orgis, licensed under GPLv2
	
	There is a lot of copying from input_file ... things shall be consolidated.
	For example, the error storage and methods shall wander into an own class.
*/

#include <sys/types.h>
#include <string>
#include <vector>

#include "audio/audio_buffer.hxx"
#include "blocks/audio_file_headers.hxx"
#include "out/output_file_types.hxx"

class output_file: public audio::sink
{
	// Use the pseudo-template. See the referenced file for details.
	#define NMSPACE output
	#include "blocks/audio_file.hxx"
	#undef NMSPACE

	output_file(const output::type_id thetype);
	virtual ~output_file();

	// === API that needs to be implemented. ===

	// Opening without location shall open some internal default.
	virtual bool  do_open(const std::string location = "") = 0;
	// Call that from the outside.
	bool do_open_safe(const std::string location = "")
	{
		do_close();
		position = 0;
		return do_open(location);
	};
	virtual void  do_close() = 0;
	// virtual bool  do_seek(off_t pos) = 0;
	// virtual off_t do_length() = 0;
	// Silent failure per default...
	// virtual bool  do_eq(const std::vector<float> &val){ return true; };

	// === End of API. ===
};
#endif
