// Common methods for output_file.

#include "out/output_file.hxx"
#include "param_init.hxx"

#include "debug.hxx"
#define ME "output_file"

output_file::output_file(const output::type_id thetype):
	 sink(std::string(ME "(") + output::id_to_name(thetype) + ")")
	,type(thetype)
{
	CONSTRUCT(ME);
	format.encoding = audio::audio_io_code;
	format.channels = param.as_uint("channels");
	format.rate = param.as_ulint("audio_rate");
	MDEBUG("An " ME " of type %s, %u channels, %lu Hz", output::id_to_name(type), format.channels, format.rate);
}

// Need to define that here to avoid the  undefined reference to `vtable for output_file'.
output_file::~output_file(){ DESTRUCT("output_file"); }
