/*
	out_text: text output device
	
	part of DerMixD
	(c)2005-2010 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "out/drv/out_text.hxx"

#include <fcntl.h>

#include <string>
using std::string;

#include "debug.hxx"
#define ME "text_output"

text_output::text_output(): output_file(output::text)
{
	CONSTRUCT(ME);
}

text_output::~text_output()
{
	DESTBEGIN(ME);
	do_close();
	DESTEND(ME);
}

bool text_output::do_write(const void* abuf, size_t bytes)
{
	const audio_io_type *buf = (const audio_io_type*)abuf;
	size_t samples = format.bytes2samples(bytes);
	for(size_t i = 0; i < samples*format.channels; i+=format.channels)
	{
		for(unsigned int ch = 0; ch < format.channels; ++ch)
		{
			if(ch) file << "\t";
			file << buf[i+ch];
		}
		file << "\n";
	}
	return true;
}

bool text_output::do_open(const std::string location)
{
	file.clear();
	file.open(location != "" ? location.c_str() : "/dev/stdout");
	if(file.is_open())
	{
		file << "#audio text printout" << "\n" << "#";
		for(unsigned int ch = 0; ch < format.channels; ++ch)
		{
			if(ch) file << "\t";
			file << "channel" << ch;
		}
		file << "\n";
		return true;
	}
	else err.occur(dmd::err::IO, "Cannot open output file.");

	return false;
}

void text_output::do_close()
{
	file.close();
}
