/*
	out_raw_s16: RAW stereo 16bit output device
	
	part of DerMixD
	(c)2005-2010 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "out/drv/out_raw_s16.hxx"

#include <fcntl.h>

#include <string>
using std::string;

#include "debug.hxx"
#define ME "raw_s16_output"

raw_s16_output::raw_s16_output(): output_file(output::raw_s16), fd(-1)
{
	CONSTRUCT(ME);
}

raw_s16_output::~raw_s16_output()
{
	DESTBEGIN(ME);
	do_close();
	DESTEND(ME);
}

bool raw_s16_output::do_write(const void* buf, size_t bytes)
{
	ssize_t ret = write(fd, buf, bytes);
	return (ret >= 0 && (size_t)ret == bytes);
}

bool raw_s16_output::do_open(const std::string location)
{
	fd = open(location != "" ? location.c_str() : "/dev/stdout", O_WRONLY|O_CREAT|O_APPEND, 0666);
	return (fd >= 0);
}

void raw_s16_output::do_close()
{
	if(fd >= 0) close(fd);

	fd = -1;
}
