/*
	out_oss: oss output device
	
	part of DerMixD
	(c)2004-2010 Thomas Orgis, licensed under GPLv2
*/

/*
	initially adapted from mixplayd 0.55... a long time ago

	Basically, I took the code and wrapped a c++ class around it.
	Of course it grew (and shrunk) to look quite different than before...

	OSS output is rather trivial in any case, so one can consider this piece of code as original as any other OSS output code.
*/

#include "basics.hxx"
#include "out/drv/out_oss.hxx"

#include <sys/ioctl.h>
#include <fcntl.h>

#include <sys/soundcard.h>
#include "secsleep.hxx"

#include <string>

#include "debug.hxx"
#define ME "oss_output"

oss_output::oss_output(): output_file(output::oss), fd(-1)
{
	CONSTRUCT(ME);
}

oss_output::~oss_output()
{
	DESTBEGIN(ME);
	do_close();
	DESTEND(ME);
}

bool oss_output::do_write(const void* buf, size_t bytes)
{
	// We do not check the actual amount of bytes written. One might for outputs writing to real files.
	ssize_t ret = write(fd, buf, bytes);
	MDEBUG("["ME" %p] written %zi of %zu bytes.", this, ret, bytes);
	return ret >= 0;
}

bool oss_output::do_open(const std::string location)
{
	std::string device = location;
	if(device == "") device = "/dev/dsp";

	MDEBUG(ME " opening %s", device.c_str());

	int oss_stereo = (format.channels == 2) ? 1 : 0;
	// look for possible formats in sys/soundcard.h
	int oss_format = AFMT_S16_NE; // signed 16bit host endinaness

	if((fd=open(device.c_str(),O_WRONLY,0)) < 0)
	{
		err.occur(dmd::err::BAD_FILE, "Cannot open OSS device.");
		return false;
	}

	fcntl(fd, F_SETFD, FD_CLOEXEC); //close on exec (after forking) - sense???

	//I don't want duplex here... I want simple blocking output!
	//hm, how do I get it?
	//ioctl(fd, SNDCTL_DSP_SETDUPLEX, 0);
	//ioctl(fd, DSP_CAP_DUPLEX, 0);

	if(ioctl(fd,SNDCTL_DSP_SETFMT,&oss_format) != 0)
	{
		err.occur(dmd::err::IO, "Cannot set format.");
		goto bad_end;
	}

	//OSS handbook indicates that ioctl may succeed but hardware still may not support the format
	if(oss_format != AFMT_S16_NE)
	{
		err.occur(dmd::err::IO, "Not the format I expected.");
		goto bad_end;
	}

	if(ioctl(fd,SNDCTL_DSP_STEREO,&oss_stereo) != 0)
	{
		err.occur(dmd::err::IO, "Cannot set stero mode.");
		goto bad_end;
	}

	if(ioctl(fd,SNDCTL_DSP_SPEED,&(format.rate)) != 0)
	{
		err.occur(dmd::err::IO, "Cannot set sample rate.");
		goto bad_end;
	}

	SDEBUG(ME " successfully opened.");
	// The good end.
	return true;

bad_end:
	do_close();
	return false;
}

void oss_output::do_close()
{
	if(fd >= 0) close(fd);

	fd = -1;
}
