This needs updating on a Tru64 box!

/*
	out_mme: mme output device (for MME on Tru64 Unix)
	
	part of DerMixD
	(c)2005-2010 Thomas Orgis, licensed under GPLv2
	
	I peeked at the tru64mme xmms output and finally some Compaq Multimedia Services docs I found online...
*/

#include "basics.hxx"
#include <mme/mme_api.h>

#include "out/drv/out_mme.hxx"
#include "debug.hxx"


struct my_private
{
	HWAVE wave_device;
	PCMWAVEFORMAT* wave_format;
	WAVEHDR* wave_header;
};


//this means the mme api of Tru64 ... probably one could make this work on Windows, too.
const string mme_output::t = "mme";


//one has to think of something else here to allow multiple instances of this output
//I don't really need it, so coding it to work for one at least.

//in principle this is a shared variable between threads and one could use some locking...
//or some extreme care;-) let's see

volatile int workbuffers = 0;

//does basically nothing...
void CALLBACK mmecallback(HWAVEOUT device, UINT message, DWORD dwInstance, LPARAM lParam1, LPARAM lParam2)
{
	#ifdef DEBUG_OUTPUT
	cerr << "[mme_output " << dwInstance << "] callback with message " << message << endl;
	#endif
	if(message == WOM_DONE) --workbuffers; //
}

void* mme_writer(void* p)
{
	outwriter* data = (outwriter*) p;
	mme_writerextra* extra = (mme_writerextra*) data->extra;
	#ifdef DEBUG_OUTPUT
	cerr << "[mme_output] writer thread started" << endl; 
	#endif
	data->thread_workout(0);
	while(1)
	{
		#ifdef DEBUG_OUTPUT
		cerr << "[mme_output] writer thread waiting" << endl; 
		#endif
		
		safe_sem_wait(&data->insem); //"Gimme some work!"
		data->error = 0; //nothing went wrong yet
		
		extra->wave_header->lpData = (char*) const_cast<audio_io_type*> (data->buffer.ptr);
		
		if((data->error = waveOutWrite(*extra->wave_device,extra->wave_header,sizeof(WAVEHDR))) != MMSYSERR_NOERROR);
		{
			#ifdef DEBUG_OUTPUT
			cout << "[mme_output] write error: " << data->error << "!\n"; 
			#endif
			data->error = 1;
		}
		else
		{
			++workbuffers;
			data->error = 0;
			while(workbuffers > 1)
			{
				//wait for an process the DONE callback
				mmeWaitForCallbacks();
				mmeProcessCallbacks();
			}
		}

		sem_post(&data->outsem); //"Hey, I'm done!"
	}
	pthread_exit(NULL);
}

mme_output::mme_output(output_data* odi, unsigned int bufsize)
{
	CONSTRUCT("mme_output");
	/*
		build() makes standard init, executes special_init() and starts the writer thread.
		Normally you call only build() here and have special init stuff in special_init().
	*/
	build(odi, bufsize, mme_writer);
}

/*
	Wonders of C++... there are limits to virtuality
	
	You _must_ call destroy() here and please put all custom destruction stuff into special_exit() unless you _really_ know what you are doing!
*/
mme_output::~mme_output()
{
	DESTBEGIN("mme_output");
	// sleep(1);
	destroy();
	// sleep(1);
	DESTEND("mme_output");
}

bool mme_output::special_init()
{
	//initialize any special stuff here...
	//...like variables for the writer
	workbuffers = 0;
	wave_header = (WAVEHDR*) mmeAllocMem(sizeof(WAVEHDR));
	wave_format = (PCMWAVEFORMAT*) mmeAllocMem(sizeof(PCMWAVEFORMAT));
	wave_format->wBitsPerSample = sizeof(audio_io_type)*8; //16Bit
	wave_format->wf.nChannels = data->format.channels;
	wave_format->wf.nSamplesPerSec = data->format.rate;
	wave_format->wf.wFormatTag = WAVE_FORMAT_PCM;
	wave_format->wf.nBlockAlign = wave_format->wf.nChannels * wave_format->wBitsPerSample / 8;
	wave_format->wf.nAvgBytesPerSec = wave_format->wf.nSamplesPerSec * wave_format->wf.nBlockAlign;
	wextra.wave_device = &wave_device;
	wextra.wave_header = wave_header;
	owriter.extra = (void*) &wextra; //add pointer to custom data structure to the writer's data structure
	good_writer_error = MMSYSERR_NOERROR;
	return true; //return false if sth. failed here
}

void mme_output::special_exit()
{
	//need to free MME shared buffers, resizing to 0 does that
	#ifdef DEBUG_OUTPUT
	cerr << "[mme_output] special_exit: resize buffer to 0" << endl;
	#endif
	resize_buffer(0);
	#ifdef DEBUG_OUTPUT
	cerr << "[mme_output] special_exit: free wave_format" << endl;
	#endif
	mmeFreeMem(wave_format);
	#ifdef DEBUG_OUTPUT
	cerr << "[mme_output] special_exit: free wave_header" << endl;
	#endif
	mmeFreeMem(wave_header);
	#ifdef DEBUG_OUTPUT
	cerr << "[mme_output] special_exit: done" << endl;
	#endif
}

bool mme_output::special_activate()
{
	bool succ = false;
	//buffer may have changed... update the header (the actual buffer pointer in the header gets set in the writer!)
	wave_header->dwBufferLength = buffer.mysize();
	wave_header->dwBytesRecorded = 0;
	wave_header->dwUser = 0;
	wave_header->dwFlags = 0;
	wave_header->dwLoops = 0;
	wave_header->lpNext = NULL; //is using this mandatory for getting smooth playback?
	if
	(
		waveOutOpen(&wave_device, WAVE_MAPPER, &(wave_format->wf), (void (*)()) &mmecallback, data->id, (CALLBACK_FUNCTION | WAVE_OPEN_SHAREABLE))
		==
		MMSYSERR_NOERROR
	)
	{
		mmeWaitForCallbacks(); //wait for OPEN callback
		mmeProcessCallbacks(); //process it
		succ = true;
	}
	return succ;
}


void mme_output::special_deactivate()
{
	while(workbuffers > 0)
	{
		//wait for an process the DONE callback
		mmeWaitForCallbacks();
		mmeProcessCallbacks();
	}
	if (mmeCheckForCallbacks())	mmeProcessCallbacks();
	if (waveOutReset(wave_device) != MMSYSERR_NOERROR)
	cerr << "[mme_output " << data->id << "] has trouble resetting!" << endl;
	else
	{
	  if (mmeCheckForCallbacks())	mmeProcessCallbacks();
		if (waveOutClose(wave_device) != MMSYSERR_NOERROR)
		cerr << "[mme_output " << data->id << "] has trouble closing!" << endl;
	}
}

void mme_output::special_pause()
{
	#ifdef DEBUG_OUTPUT
	cerr << "[mme_output " << data->id << "] pause" << endl; 
	#endif
	//prepare for future silence... workaround for OSS; future of this method being unsure
}

//overriding the default buffer resize!
//swapping should still be natural...
bool mme_output::resize_buffer(unsigned int s)
{
	//there should be nothing pending!
	#ifdef DEBUG_OUTPUT
	cerr << "[mme_output " << data->id << "] resize_buffer to " << s << endl;
	#endif
	bool ret = true;
	//we work with 2 buffers!
	if(buffer.ptr != NULL){ mmeFreeBuffer(const_cast<audio_io_type*> (buffer.ptr)); buffer.size = buffer.fill = 0; }
	if(owriter.buffer.ptr != NULL){ mmeFreeBuffer(const_cast<audio_io_type*> (owriter.buffer.ptr)); owriter.buffer.size = owriter.buffer.fill = 0; }
	
	if(s)
	{
		if( (buffer.ptr = const_cast<volatile audio_io_type*> ((audio_type*) mmeAllocBuffer(sizeof(audio_type)*data->format.channels*s))) == 0)
			ret = false;
		else
		{
			buffer.size = s;
			buffer.fill = 0;
			buffer.zero();
		}
		if( (owriter.buffer.ptr = const_cast<volatile audio_io_type*> ((audio_type*) mmeAllocBuffer(sizeof(audio_type)*data->format.channels*s))) == 0)
			ret = false;
		else
		{
			owriter.buffer.size = s;
			owriter.buffer.fill = 0;
			owriter.buffer.zero();
		}
	}
	
	return ret;
}

