/*
	out_dummy: dummy output device
	
	part of DerMixD
	(c)2004-2010 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "out/drv/out_dummy.hxx"
//needed to fake work
#include "secsleep.hxx"

#include <string>
using std::string;

#include "debug.hxx"
#define ME "dummy_output"

dummy_output::dummy_output(): output_file(output::dummy), time_factor(0.95)
{
	CONSTRUCT(ME);
}

dummy_output::~dummy_output()
{
	DESTBEGIN(ME);
	do_close();
	DESTEND(ME);
}


bool dummy_output::do_write(const void* buf, size_t bytes)
{
	secsleep((double) time_factor/format.rate*format.bytes2samples(bytes));
	return true;
}

bool dummy_output::do_open(const std::string location)
{
	return true;
}

void dummy_output::do_close()
{
	return;
}
