#ifndef DMD_H_MUTEX
#define DMD_H_MUTEX
/*
	mutex: A simple wrapper over a POSIX mutex lock, to be used as parent class, even.

	part of DerMixD
	(c)2007-9 Thomas Orgis, licensed under GPLv2

	The actual nature of the lock is hidden, so in theory this could serve to abstract a bit of POSIX-ness away.
*/

// Generic mutex. Offers locking and unlocking, without guarantee about implementation.
// This severely needs to be wrapped into the dmd namespace, as Sun Studio seems to sport a conflicting mutex.
class mutex
{
	public:
	mutex(){};
	~mutex(){};
	virtual void lock() = 0;
	virtual void unlock() = 0;
};

// A real synchronizing mutex.
class real_mutex: public mutex
{
	private:
	struct my_private;
	struct my_private *parts;

	public:
	 real_mutex();
	~real_mutex();
	void lock();
	void unlock();
};

// A mutex that actually wraps over another mutex, or reduces to no-op.
// The possibly underlying real mutex is created and destroyed outside!
class optional_mutex: public mutex
{
	public:
	optional_mutex(mutex *mammi = NULL);
	~optional_mutex();
	void   lock(){ if(mutti != NULL) mutti->lock();   };
	void unlock(){ if(mutti != NULL) mutti->unlock(); };

	// Heck, you are allowed to change it from the outside, even.
	// The logic is simple: When this is non-NULL, it is used for real in the lock()/unlock() methods.
	// It's _not_ deleted for you.
	mutex *mutti;
};

// Lock a mutex as long as the instance exists. RAII.
// Bonus point for reducing to no-op if given mutex pointer is NULL.
class locker
{
	public:
	locker(mutex *muffin = NULL): mutinity(muffin) { if(mutinity) mutinity->lock(); };
	~locker(){ if(mutinity) mutinity->unlock(); };
	private:
	mutex *mutinity;
};

#endif
