/*
	mutex: A simple wrapper over a POSIX mutex lock, to be used as parent class, even.

	part of DerMixD
	(c)2007-9 Thomas Orgis, licensed under GPLv2
*/

#include <pthread.h>
// #include <cstdio>
#include "mutex.hxx"
#include "debug.hxx"

// This is the gory detail that actually works with POSIX thread API.

struct real_mutex::my_private { pthread_mutex_t lock; };

real_mutex::real_mutex() : parts(new my_private)
{
	CONSTRUCT("real_mutex");
	// It's a bit wasting to do runtime allocation here, but it serves for hiding the POSIX API details.
	parts = new my_private;
	pthread_mutex_init(&parts->lock, NULL);
}

real_mutex::~real_mutex()
{
	DESTBEGIN("real_mutex");
	pthread_mutex_destroy(&parts->lock);
	delete parts;
	DESTEND("real_mutex");
}

void real_mutex::lock()  { pthread_mutex_lock  (&parts->lock); }
void real_mutex::unlock(){ pthread_mutex_unlock(&parts->lock); }

// The optional wrapper is rather simplistic. Not inlined in the header to keep the structure clean. When you are dealing with POSIX thread switching you probably don't care about inlining of the code to do so... or do you?

optional_mutex::optional_mutex(mutex *mammi): mutti(mammi)
{
	CONSTRUCT("optional_mutex");
}

optional_mutex::~optional_mutex()
{
	DESTRUCT("optional_mutex");
}
