/*
	module: dynamic loadable pieces of code (wrapper over dlopen())

	part of DerMixD
	(c)2011 Thomas Orgis, licensed under GPLv2

	Am I sure about the dl error return values? the header is a bit sparsely documented on this.
*/

#include "basics.hxx"
#include "module.hxx"
#include <dlfcn.h>

#include "debug.hxx"

namespace dmd
{

static const char* me = "module";

module::module(): err(me), dlhandle(NULL), dlflags(RTLD_NOW)
{
	CONSTRUCT(me);
}

module::~module()
{
	DESTBEGIN(me);
	close();
	DESTEND(me);
}

bool module::open(const std::string name)
{
	close();
	dlhandle = dlopen(name.c_str(),dlflags);
	if(dlhandle == NULL)
	return err.occur(dmd::err::IO, (std::string)"cannot open module (" + safe_string(dlerror())+ ")");
	else
	return true;
}

void module::close()
{
	if(dlhandle != NULL)
	dlclose(dlhandle);
}

void* module::get_symbol(const std::string name)
{
	void *location;
	location = dlsym(dlhandle, name.c_str());
	if(location == NULL)
	err.occur(dmd::err::IO, (std::string)"cannot find symbol (" + safe_string(dlerror())+ ")");

	return location;
}

}
