#ifndef DMD_H_MIXING_BUFFER
#define DMD_H_MIXING_BUFFER
/*
	mixing_buffer: a buffer that's being mixed into

	part of DerMixD
	(c)2010 Thomas Orgis, licensed under GPLv2

	This is essentially a mixer buffer with a mutex to serialize adding several inputs.
*/

#include "audio/audio_buffer.hxx"
#include "mutex.hxx"

class mixing_buffer: public mixer_buffer, public real_mutex
{
	public:
	 mixing_buffer(): mixer_buffer() {};
	 mixing_buffer(size_t s): mixer_buffer(s) {};
	 mixing_buffer(unsigned int c, size_t s): mixer_buffer(c,s) {};
	~mixing_buffer() {};
	// Mix in the contents of the given buffer, return the number of samples actually consumed.
	// This number may be limited by the input buffer fill or the size of this mixing buffer.
	size_t mix_in(const mixer_buffer &in, size_t offset=0);
	// Convert the mixing buffer to the output device buffer.
	// That's clipping and conversion to 16 bit for now.
	// Could mean channel mixing and resampling, too (future).
	// This zeroes the mixing buffer.
	void mix_down(audio_buffer *out);
};



#endif
