/*
	mixing_buffer: a buffer that's being mixed into

	part of DerMixD
	(c)2010 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "mixing_buffer.hxx"

#include "debug.hxx"

size_t mixing_buffer::mix_in(const mixer_buffer &in, size_t offset)
{
	size_t consumed = 0;
	lock();
	if(offset < size && channels == in.channels) // Paranoid...
	{
		consumed = in.fill;
		if(consumed > size-offset) consumed = size-offset;

		for(size_t i=0; i<consumed*channels; ++i)
		ptr[i] += in.ptr[i];

		if(fill < offset+consumed) fill = offset+consumed;

		MXDEBUG("[mixing_buffer %p] mixed in, fill=%zu", this, fill);
	}
	else MERROR("[mixing_buffer %p] Bad offset or chanel cound for mix in.", this);
	unlock();
	return consumed;
}

void mixing_buffer::mix_down(audio_buffer *out)
{
	fill = size; // Hack: We always put out full buffers (possibly with silence included).
	if(out->size != size || out->channels != channels)
	{
		MERROR("[mixing_buffer %p] Bad output buffer!", this);
		return;
	}
	size_t bytes;
	audio::encode_to(audio::audio_io_code, ptr, channels, fill, out->ptr, bytes);
	// This should be the same as input samples!
	out->fill = audio::bytes_to_samples(audio::audio_io_code, bytes) / out->channels;
	MXDEBUG("[mixing_buffer %p] mixed down %zu bytes (%zu samples)", this, bytes, out->fill);
	zero();
}
