#ifndef H_DMD_MIXER_WORKER
#define H_DMD_MIXER_WORKER
/*
	mixer_worker: A thread that offloads work from the mixer.

	part of DerMixD
	(c)2009 Thomas Orgis, licensed under GPLv2

	This starts out as a dummy to receive error messages for unattended operations, but in future it is supposed to actually do work that can be offloaded from the main mixer.
	I think about distributing status info to clients, buffering in general... and of course, actually attend to these unattended actions.
*/

#include "threads/threads.hxx"
#include "threads/semaphore.hxx"
#include "coms/comm_data.hxx"
#include "actionlist.hxx"
#include "coms/client_action_handler.hxx"
#include <vector>
#include <string>

class mixer_worker: public dmd::thread
{
	public:
	comm_data comdat;
	mixer_worker(dmd::actionlist &actions, semaphore &clients_go);
	~mixer_worker();
	void thread_work();

	private:
	dmd::actionlist *actions;
	semaphore *clients_go;
	// All data needed for defsetup also here, so that it can be cleaned up properly when cancelled _during_ defsetup.
	dmd::client_action_handler actor;
	std::vector<std::string> defscript;
	// Need the iterator here so that it's destructed on canellation.
	std::vector<std::string>::iterator defcmd;
	// I cannot even construct temporary string objects for calling functions that may get cancelled!
	std::string cmd;
	bool defsetup();

};

#endif
