/*
	mixer_worker: A thread that offloads work from the mixer.

	part of DerMixD
	(c)2009 Thomas Orgis, licensed under GPLv2
*/


#include "basics.hxx"
#include "mixer/mixer_worker.hxx"
#include "syserror.hxx"
#include "threads/semaphore.hxx"
#include "tstring.hxx"

#include "param_init.hxx"

#include <string>
#include <vector>
// #include <cstdio>

#include "shortcuts.hxx"
#include "debug.hxx"

using std::string;
using std::vector;

mixer_worker::mixer_worker(dmd::actionlist &mixacts, semaphore &go_clients):
	 thread("mixer_worker", dmd::nice::mixer_worker)
	,actions(&mixacts), clients_go(&go_clients)
	,actor(*this, mixacts)
{
	CONSTRUCT("mixer_worker");
}

mixer_worker::~mixer_worker()
{
	DESTRUCT("mixer_worker");
}

// Yeah, I'm still paranoid about allocating storage inside a thread.
// msgs should actually be a local variable in the loop.
void mixer_worker::thread_work()
{
	// We count the error events that occured.
	unsigned long err_events = 0;
	// Wait for some action, check if it had errors, print these.
	fprintf(stderr, "Mixer worker online.\n");
	// Might get cancelled here.
	// Fuck! Even that temorary string created as argument to param.as_bool() seems to leak memory when getting cancelled in defsetup()!
	// Does it work when I separate the two conditions?
	// if(param.as_bool("defsetup") && !defsetup()) return;
	if(param.as_bool("defsetup"))
	{
		// Normally, I'll get cancelled inside defsetup on error...
		if(!defsetup()) return;
	}

	// If defsetup was successful, give the global signal to allow connections from clients.
	clients_go->post();

	// Cancellation only possible when waiting on the semaphore!
	while(comdat.waitress->wait(this))
	{
		fprintf(stderr, "[mixer_worker %p] Somebody called, but I do not yet know how do do anything.\n", this);
	}
	MERROR("[mixer_worker %p] I should not have reached that point... something went wrong.", this);
}

// Work through the startup script (to come from a file in future), if some failure occurs, the server gets the signal to end everything before it truly began.
bool mixer_worker::defsetup()
{
	fprintf(stderr, "Running default setup...\n");

	// In future, these are all tasks actually to be executed by this very thread here!
	defscript.push_back("addout Helena");
	defscript.push_back("outload 0 default default");
	defscript.push_back("addin Lena");
	defscript.push_back("addin Elena");
	defscript.push_back("bind 0 0");
	defscript.push_back("bind 1 0");

	// No local allocation of an iterator when there is possible cancellation inside...
	for(defcmd = defscript.begin(); defcmd != defscript.end(); ++defcmd)
	{
		// I need to handle that action just like a socketeer.
		// A little flaw: I should add error detection. To abort operation if startup script fails (or not?).
		fprintf(stderr, "STARTUP: %s\n", defcmd->c_str());
		// I may be cancelled here.
		actor.handle(*defcmd);
		// I may not be cancelled here.
		FOR_VECTOR(string*, actor.answers, l)
		{
			fprintf(stderr, "%s\n", (*l)->c_str());
			delete *l;
		}
		actor.answers.clear();
		if(actor.got_error) break;
	}

	if(actor.got_error)
	{
		MERROR("[mixer_worker %p] A default setup action failed... blowing the whistle for breakdown.", this);
		// I may be cancelled here.
		cmd = "shutdown";
		actor.handle(cmd);
		return false;
	}

	fprintf(stderr,  "That went fine... I'll conclude the initial setup with a full listing:\n");
	cmd = "fullstat";
	actor.handle(cmd);
	FOR_VECTOR(string*, actor.answers, l)
	{
		fprintf(stderr, "%s\n", (*l)->c_str());
		delete *l;
	}
	actor.answers.clear();

	return true;
}
