/*
	mixer_sink: A catch-all message sink for lost communication.

	part of DerMixD
	(c)2009-2013 Thomas Orgis, licensed under GPLv2
*/


#include "basics.hxx"
#include "mixer/mixer_sink.hxx"
#include "syserror.hxx"
#include "threads/semaphore.hxx"
#include "tstring.hxx"

#include <string>
#include <vector>
// #include <cstdio>

#include "shortcuts.hxx"
#include "debug.hxx"

using std::string;
using std::vector;

// Special comm_data: Giving it a mutex to protect itself.
// This must be cleaned up here, too.

mixer_sink::mixer_sink(): thread("mixer_sink", dmd::nice::mixer_sink)
	,comdat(NULL, new real_mutex)
{
	CONSTRUCT("mixer_sink");
}

mixer_sink::~mixer_sink()
{
	DESTBEGIN("mixer_sink");
	delete comdat.mutti;
	DESTBEGIN("mixer_sink");
}

// Yeah, I'm still paranoid about allocating storage inside a thread.
// msgs should actually be a local variable in the loop.
void mixer_sink::thread_work()
{
	// We count the error events that occured.
	unsigned long err_events = 0;
	// TODO: Confirm that all prospective posters use locking on comdat.
	// Wait for some action, check if it had errors, print these.
	// Cancellation only possible when waiting on the semaphore!
	while(comdat.waitress->wait(this))
	{
		{ // The critical section for working with comdat.
			locker room(&comdat);

			fprintf(stderr, "%s", "[mixer_sink] Got some homeless message/errors:\n");
			// There could be multiple error chains stacked up.
			// Also, retlines could be from several operations.
			// Just a heads-up. Does it matter?
			if(comdat.errors.count())
			{
				size_t i = 0;
				++err_events;
				comdat.errors.stringify(msgs);
				fprintf(stderr, "Error event %lu:\n", err_events);
				FOR_VECTOR(string*, msgs, s) fprintf(stderr, "%zu: %s\n", ++i, (*s)->c_str());
			}
			// Retlines need to be cleared up, too. By principle.
			FOR_VECTOR(std::string*, comdat.retlines, s) delete (*s);
			comdat.clear(); // That empties error list, too.
		}
		// Message list shall be empty for next run.
		// Hm, that calls for another macro, actually. Or API support in vector class.
		FOR_VECTOR(string*, msgs, s) delete (*s);
		msgs.clear();
	}
	MERROR("[mixer_sink %p] I should not have reached that point... something went wrong.", this);
}
