#ifndef DMD_H_MIXER_RACK
#define DMD_H_MIXER_RACK

/*
	mixer_rack: Core data for the mixer.

	All channels and associated effect machines as well as a tangle
	of patching cable secured in a common rack.

	part of DerMixD
	(c)2004-2012 Thomas Orgis, licensed under GPLv2
*/

#include "threads/readwrite_barrier.hxx"
#include "channel.hxx"
#include "inchannel.hxx"
#include "outchannel.hxx"


#include <vector>
#include <string>

namespace dmd
{

// Will gain methods as functionality is extracted from mixer class.
// For now mainly holding the data.
class mixer_rack
{
	public:
	mixer_rack();
	~mixer_rack();
	// Many people can look at the rack, but there is only one screwdriver.
	// I am planning on doing tasks potentially in parallel, at least
	// during a transition phase; and then I could run with it.
	// Client action handlers could even do work on their own, at least
	// reading stuff.
	// This barrier ensures that global properties like the channel list
	// do not change. Individual channel state is in flux and needs to
	// be synchronized individually.
	readwrite_barrier the_wall;
	// Sets of input and output channels...
	std::vector<inchannel*> inners;
	std::vector<outchannel*> outers;
};

}
#endif
