#ifndef DMD_H_MIXER_ACTIONS
#define DMD_H_MIXER_ACTIONS

/*
	mixer_actions: outsourced code for mixer's daily work
	
	part of DerMixD
	(c)2004-9 Thomas Orgis, licensed under GPLv2
*/

void set_compat_stats(vector<inchannel*> &inners, vector<outchannel*> &outers, vector<string*> *compat_stats);
void set_stats(vector<inchannel*> &inners, vector<outchannel*> &outers, vector<string*> *stats);
unsigned char add_output(vector<outchannel*> &outers, string &name);
unsigned char add_input(vector<inchannel*> &inners, string &name, sem_t &insem);
unsigned char remove_input(vector<inchannel*> &inners, vector<outchannel*> &outers,int &num);
unsigned char remove_output(vector<inchannel*> &inners, vector<outchannel*> &outers,int &num);
unsigned char bind_input(inchannel* in, outchannel* out);

void in_watch(inchannel* inch, socket_writer* swr);
void in_unwatch(inchannel* inch, socket_writer* swr);
void unwatch_all(vector<inchannel*> &inners, socket_writer* swr);

void telltime(inchannel* inch);

void unbind_source(inchannel* inch, outchannel* outch);
void unbind_target(inchannel* inch, outchannel* outch);

void process_actions(vector<action*> &acts, mixer_worker &hermes);

#endif
