#ifndef DMD_H_MIXER
#define DMD_H_MIXER

/*
	mixer: the mixer, the master, the gate, the keeper
	
	part of DerMixD
	(c)2004-2010 Thomas Orgis, licensed under GPLv2
*/

#include "mutex.hxx"
#include "threads/semaphore.hxx"
#include "threads/threads.hxx"
#include "mutex.hxx"
#include "threads/semaphore.hxx"
#include "actionlist.hxx"
#include "audio/audio_buffer.hxx"

#include "mixer/mixer_rack.hxx"
#include "mixer/mixer_sink.hxx"
#include "mixer/mixer_worker.hxx"


#include <vector>
#include <string>

// Hackish... a global mutex that is taken during critical mixer work.
// This is to ensure that background tasks (that block on that mutex) do not disturb the more urgent mixer work.
// This should at least be a member of the mixer class and handed down...
extern real_mutex playlock;

namespace dmd
{


class mixer: public thread_container
{
	public:
	dmd::actionlist actions;

	// You hand in a semaphore that the mixer will post on when it is ready for accepting client action requests.
	 mixer(semaphore &clients_go);
	~mixer();
	// More elaborate initialization does not happen in constructor... call this and chek its return success status.
	bool init();
	// Clean up stuff that init() created (like worker threads).
	// This is called in the destructor.
	void exit();

	// Start the party!
	bool run();

	private:
	int globalstate;
	mixer_rack rack;
	// The main mixer format... does anyone else need to know it?
	// It used to be global;
	audio_format format;
	// Size of main mixer buffers.
	size_t buffer_samples;
	channel *bla;
	// And a list of channels that have scripted actions pending.
	// I suggest that vanishes in favour of just asking all channels
	// to add their script for the next buffer, in a parallel manner.
	std::vector<channel*> scripters;
	// This semaphore is handed to inputs, to signal when they have filled their respective buffers.
	semaphore insem;
	// outsem seems superfluous...
	// The background worker thread. Does get things done.
	mixer_worker jules;
	// A sink for homeless messages. Deliver them to someone tho cares, heavenly messenger!
	mixer_sink hermes;

#ifdef LINUX
	pid_t base_pid;
	int base_priority;
#endif

	// Action processing... like the name suggests.
	void process_actions(std::vector<action*> &);
	// Action helpers...
	void set_stats(std::vector<std::string*> &);
	void add_input(action *);
	void add_output(action *);
	void remove_input(action *);
	void remove_output(action *);
	void exorcise_socket(socket_writer *);

	void handle_mixer_action(action *act);
	void handle_script(size_t samples);
	void wait_for_action();
	unsigned int fetch_input_and_mix(size_t samples);
	unsigned int dispatch_output();
};

}
#endif
