#ifndef DMD_H_MATHHELP
#define DMD_H_MATHHELP

// Do I really want that "inline" keyword?

#define minmax(type) \
static inline type min(const type a, const type b) \
{ \
	return (b < a) ? b : a; \
} \
static inline type max(const type a, const type b) \
{ \
	return (b > a) ? b : a; \
}

static const double pi = 3.14159265358979323846;

minmax(int)
minmax(size_t)
minmax(off_t)
minmax(float)
minmax(double)

static inline size_t round2size(double val)
{
	return val < 0. ? 0 : (size_t)(val+0.5);
}

static inline int round2long(double val)
{
	return val < 0. ? 0 : (long)(val+0.5);
}

#endif
