/*
	input_state: State of an input channel, communicated across threads.
	
	part of DerMixD
	(c)2009-2011 Thomas Orgis, licensed under GPLv2
*/

#include "basics.hxx"
#include "in/input_state.hxx"

input_state::input_state(mutex *locker):
	optional_mutex(locker), type(input::invalid), position(0), length(0)
{
	// Ugly hack to have defined zero-positions.
	format.rate = 1;
	eqval.resize(EQ_BANDS, 1.0);
}

input_state::~input_state(){}

void input_state::sync(input_state &source, off_t position_offset)
{
	lock();
	source.lock();

	type     = source.type;
	filename = source.filename;
	position = source.position - position_offset;
	length   = source.length;
	format   = source.format;
	eqval    = source.eqval;

	source.unlock();
	unlock();
}

void input_state::nofile()
{
	lock();
	filename = "";
	position = 0;
	length = 0;
	unlock();
}

void input_state::newfile(input::type_id ntype, audio_format *nformat, const std::string name)
{
	lock();
	position = 0;
	length = 0;
	filename = "";
	type = ntype;
	if(nformat != NULL)
	{
		format = *nformat;
		filename = name;
	}
	unlock();
}

void input_state::newformat(audio_format *nformat)
{
	lock();
	if(nformat != NULL) format = *nformat;

	unlock();
}

void input_state::set_position(off_t pos)
{
	lock();
	position = pos;
	if(position > length) length = position;
	unlock();
}

void input_state::set_length(off_t len)
{
	lock();
	length = len;
	unlock();
}
