#ifndef DMD_H_IN_FILE_TYPES
#define DMD_H_IN_FILE_TYPES

/*
	input_file_types: Common code to deal with different in/output file types.

	part of DerMixD
	(c)2009-2010 Thomas Orgis, licensed under GPLv2

	This is both the collection of respective numerical type IDs together with the mapping from/to character strings and the factory functions for creating new files with a given type.
	All other DerMixD code is supposed to work with the generic input_file / output_file classes.

	That's still ugly... but I am trying to at least consolidate the strings.
	I am stubborn in my refusal to use some std::map thingy for the static mapping that a const char* array can do.
*/

// Think about that... do we use strings or not?
// One can always pass c_str(), and that's all functionality that's needed.
#include <string>

// Every possible input file type gets an ID and a name.
// Some of them may not be built in, though.
class input_file;
namespace input
{
	typedef enum type_id
	{
		invalid = -1, // No type, really.
		#define X(a,b,c) a
		// Insert the types there...
		#include "blocks/input_types.hxx"
		#undef X
		,count // The number of types...
	} type_id;

	#include "blocks/enummap_header.hxx"
	#define FILE_TYPE input_file
	#include "blocks/file_switch_header.hxx"
	#undef FILE_TYPE
}

#endif
