#ifndef DMD_H_INPUT_FILE
#define DMD_H_INPUT_FILE
/*
	input_file: interface class for input files

	part of DerMixD
	(c)2009-2010 Thomas Orgis, licensed under GPLv2

	Yes, the input/output file classes still look messy.
*/

#include <sys/types.h>
#include <string>
#include <vector>

#include "blocks/audio_file_headers.hxx"
#include "in/input_file_types.hxx"

class input_file: public audio::source
{
	// Use the pseudo-template. See the referenced file for details.
	#define NMSPACE input
	#include "blocks/audio_file.hxx"
	#undef NMSPACE

	input_file(const input::type_id thetype);
	virtual ~input_file();

	// === API that needs to be implemented. ===

	// virtual bool  do_read(audio_io_type* buf, size_t wanted_samples, size_t &got_samples) = 0;
	virtual bool  do_open(const std::string location) = 0;
	// User code shall call this one, derived classes don't need to reset position, or care for closing before open.
	bool do_open_safe(const std::string location)
	{
		do_close();
		position = 0;
		return do_open(location);
	};
	virtual void  do_close() = 0;
	virtual bool  do_seek(off_t pos) = 0;
	virtual off_t do_length() = 0;
	// Silent failure per default...
	virtual bool  do_eq(const std::vector<float> &val){ return true; };

	// === End of API. ===
};
#endif
