// Common methods for input_file.

#include "in/input_file.hxx"
#include "debug.hxx"

#define ME "input_file"

input_file::input_file(const input::type_id thetype):
	 audio::source(std::string(ME "(") + input::id_to_name(thetype) + ")")
	,type(thetype)
{
	CONSTRUCT(ME);
	format.encoding = audio::audio_io_code;
	MDEBUG("An " ME " of type %s.", input::id_to_name(type));
}

// Need to define that here to avoid the  undefined reference to `vtable for input_file'.
input_file::~input_file(){ DESTRUCT(ME); }
